/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.visio.model.mapping;

import filenet.vw.api.VWActionType;
import filenet.vw.api.VWAssociationDefinition;
import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWTextAnnotationDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.visio.model.Shape;
import filenet.vw.toolkit.design.visio.model.mapping.VWContainerItem;
import filenet.vw.toolkit.design.visio.model.mapping.VWMappingHelper;
import filenet.vw.toolkit.design.visio.resources.VWResource;
import filenet.vw.toolkit.utils.VWFunctionStrings;
import filenet.vw.toolkit.utils.VWInstruction;
import filenet.vw.toolkit.utils.VWStepFactory;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.Point;
import java.util.Vector;

class VWMapItem
extends VWContainerItem {
    private static final int X_LOCATION_PADDING = 50;
    private static final int Y_LOCATION_PADDING = 50;
    private VWMapDefinition m_myMapDef = null;
    private Vector m_startStepList = null;
    private Vector m_stepList = null;
    private Vector m_routeList = null;
    private Vector m_textAnnotationList = null;
    private Vector m_associationList = null;
    private Vector m_onPageReferences = null;
    private Vector m_offPageReferences = null;
    private double m_pinXOffset = 0.0;
    private double m_pinYOffset = 0.0;

    protected VWMapItem(Shape myShape, VWMapDefinition myMapDef) {
        super(myShape);
        this.m_myMapDef = myMapDef;
        this.m_onPageReferences = new Vector();
        this.m_offPageReferences = new Vector();
    }

    protected String getName() {
        if (this.m_myMapDef != null) {
            return this.m_myMapDef.getName();
        }
        return null;
    }

    protected boolean hasReferencedShapes(Shape shape) {
        if (shape != null) {
            String referencedShapeId = shape.getReferenceShapeId();
            for (int nIndex = 0; nIndex < this.m_offPageReferences.size(); ++nIndex) {
                Shape tmpShape = (Shape)this.m_offPageReferences.elementAt(nIndex);
                if (VWStringUtils.compare(tmpShape.getUniqueID(), referencedShapeId) != 0) continue;
                if (this.m_pinXOffset == 0.0 && this.m_pinYOffset == 0.0) {
                    this.m_pinXOffset = tmpShape.getXPos() - shape.getPinX();
                    this.m_pinYOffset = tmpShape.getYPos() - shape.getPinY();
                }
                return true;
            }
        }
        return false;
    }

    protected void rejustifyItems() {
        try {
            Point pt;
            boolean bHasMappedStartStep = false;
            int nMinX = 9999;
            int nMinY = 9999;
            VWMapNode[] steps = this.m_myMapDef.getSteps();
            for (int nIndex = 0; nIndex < steps.length; ++nIndex) {
                Point pt2;
                if (nIndex == 0 && steps[nIndex].getNextRoutes() != null) {
                    bHasMappedStartStep = true;
                }
                if ((pt2 = steps[nIndex].getLocation()) == null) continue;
                if (pt2.x < nMinX) {
                    nMinX = pt2.x;
                }
                if (pt2.y >= nMinY) continue;
                nMinY = pt2.y;
            }
            VWTextAnnotationDefinition[] textAnnotations = this.m_myMapDef.getTextAnnotations();
            if (textAnnotations != null) {
                for (int nIndex = 0; nIndex < textAnnotations.length; ++nIndex) {
                    pt = textAnnotations[nIndex].getLocation();
                    if (pt == null) continue;
                    if (pt.x < nMinX) {
                        nMinX = pt.x;
                    }
                    if (pt.y >= nMinY) continue;
                    nMinY = pt.y;
                }
            }
            nMinX = bHasMappedStartStep ? 50 - nMinX : 150 - nMinX;
            nMinY = 50 - nMinY;
            if (nMinX < 0 || nMinY < 0) {
                int nIndex;
                for (nIndex = 0; nIndex < steps.length; ++nIndex) {
                    pt = steps[nIndex].getLocation();
                    if (pt == null) continue;
                    pt.x += nMinX;
                    pt.y += nMinY;
                    steps[nIndex].setLocation(pt);
                }
                if (textAnnotations != null) {
                    for (nIndex = 0; nIndex < textAnnotations.length; ++nIndex) {
                        pt = textAnnotations[nIndex].getLocation();
                        if (pt == null) continue;
                        pt.x += nMinX;
                        pt.y += nMinY;
                        textAnnotations[nIndex].setLocation(pt);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected Vector setSteps(Vector stepList, VWMappingHelper mappingHelper) {
        Vector[] shapeLists;
        if (stepList != null && (shapeLists = this.findContainedShapes(stepList)) != null) {
            this.m_stepList = shapeLists[0];
            return shapeLists[1];
        }
        return stepList;
    }

    protected Vector setStartSteps(Vector startStepList) {
        Vector[] shapeLists;
        if (startStepList != null && (shapeLists = this.findContainedShapes(startStepList)) != null) {
            this.m_startStepList = shapeLists[0];
            return shapeLists[1];
        }
        return startStepList;
    }

    protected Vector setRoutes(Vector routeList) {
        Vector[] shapeLists;
        if (routeList != null && (shapeLists = this.findContainedShapes(routeList)) != null) {
            this.m_routeList = shapeLists[0];
            return shapeLists[1];
        }
        return routeList;
    }

    protected Vector setTextAnnotations(Vector textAnnotationList) {
        Vector[] shapeLists;
        if (textAnnotationList != null && (shapeLists = this.findContainedShapes(textAnnotationList)) != null) {
            this.m_textAnnotationList = shapeLists[0];
            return shapeLists[1];
        }
        return textAnnotationList;
    }

    protected Vector setAssociations(Vector associationList) {
        Vector[] shapeLists;
        if (associationList != null && (shapeLists = this.findContainedShapes(associationList)) != null) {
            this.m_associationList = shapeLists[0];
            return shapeLists[1];
        }
        return associationList;
    }

    protected void convertShapes(VWMappingHelper mappingHelper, int nPageHeight) {
        boolean bMappedStartStep = false;
        if (this.m_startStepList != null && this.m_startStepList.size() > 0) {
            if (this.m_startStepList.size() > 1) {
                mappingHelper.addMessage(2, VWResource.s_multipleMappedStartSteps);
                VWMapNode startStep = null;
                for (int nIndex = 0; nIndex < this.m_startStepList.size(); ++nIndex) {
                    Shape shape = (Shape)this.m_startStepList.elementAt(nIndex);
                    if (startStep != null) {
                        shape.setApiObject(startStep);
                        continue;
                    }
                    startStep = this.addStep(shape, mappingHelper, nPageHeight);
                }
            } else {
                Shape shape = (Shape)this.m_startStepList.elementAt(0);
                this.addStep(shape, mappingHelper, nPageHeight);
            }
            bMappedStartStep = true;
        }
        this.m_startStepList = null;
        if (this.m_stepList != null && this.m_stepList.size() > 0) {
            if (!bMappedStartStep) {
                mappingHelper.addMessage(1, VWResource.s_noMappedStartSteps);
            }
            for (int nIndex = 0; nIndex < this.m_stepList.size(); ++nIndex) {
                Shape shape = (Shape)this.m_stepList.elementAt(nIndex);
                this.addStep(shape, mappingHelper, nPageHeight);
            }
        }
        this.m_stepList = null;
        this.m_onPageReferences = new Vector();
        if (this.m_routeList != null && this.m_routeList.size() > 0) {
            for (int nIndex = 0; nIndex < this.m_routeList.size(); ++nIndex) {
                Shape shape = (Shape)this.m_routeList.elementAt(nIndex);
                this.addRoute(shape, mappingHelper);
            }
        }
        this.m_routeList = null;
        if (this.m_textAnnotationList != null && this.m_textAnnotationList.size() > 0) {
            for (int nIndex = 0; nIndex < this.m_textAnnotationList.size(); ++nIndex) {
                Shape shape = (Shape)this.m_textAnnotationList.elementAt(nIndex);
                this.addTextAnnotation(shape, mappingHelper, nPageHeight);
            }
        }
        this.m_textAnnotationList = null;
        if (this.m_associationList != null && this.m_associationList.size() > 0) {
            for (int nIndex = 0; nIndex < this.m_associationList.size(); ++nIndex) {
                Shape shape = (Shape)this.m_associationList.elementAt(nIndex);
                this.addAssociation(shape, mappingHelper);
            }
        }
        this.m_associationList = null;
        this.m_pinXOffset = 0.0;
        this.m_pinYOffset = 0.0;
    }

    private VWMapNode addStep(Shape shape, VWMappingHelper mappingHelper, int nPageHeight) {
        try {
            int nIndex;
            String stepName = shape.getText();
            if (stepName == null && shape.getSubmapName() != null) {
                stepName = shape.getSubmapName();
            }
            Point ptLoc = this.getShapeLocation(shape, mappingHelper, nPageHeight);
            VWMapNode mapNode = null;
            if (VWStringUtils.compare(shape.getNameU(), "On-page reference") == 0) {
                boolean bAddToOnPageList = true;
                if (this.m_onPageReferences != null) {
                    for (nIndex = 0; nIndex < this.m_onPageReferences.size(); ++nIndex) {
                        Shape oprShape = (Shape)this.m_onPageReferences.elementAt(nIndex);
                        if (VWStringUtils.compare(stepName, oprShape.getText()) != 0) continue;
                        mapNode = (VWMapNode)oprShape.getApiObject();
                        bAddToOnPageList = false;
                        break;
                    }
                }
                if (bAddToOnPageList) {
                    this.m_onPageReferences.addElement(shape);
                }
            } else if (VWStringUtils.compare(shape.getNameU(), "Off-page reference") == 0) {
                boolean bAddToOffPageList = true;
                if (this.m_offPageReferences != null) {
                    for (nIndex = 0; nIndex < this.m_offPageReferences.size(); ++nIndex) {
                        Shape oprShape = (Shape)this.m_offPageReferences.elementAt(nIndex);
                        if (VWStringUtils.compare(shape.getReferenceShapeId(), oprShape.getUniqueID()) != 0) continue;
                        mapNode = (VWMapNode)oprShape.getApiObject();
                        bAddToOffPageList = false;
                        break;
                    }
                }
                if (bAddToOffPageList) {
                    this.m_offPageReferences.addElement(shape);
                }
            }
            if (mapNode == null) {
                if (VWStringUtils.compare(shape.getDesignerObjectName(), VWResource.s_start) == 0) {
                    mapNode = this.m_myMapDef.getStartStep();
                    if (stepName != null) {
                        mapNode.setName(stepName);
                    }
                    VWStepFactory.setDefaultStepValues(mapNode, ptLoc);
                } else {
                    VWInstructionDefinition[] instructionDefs;
                    int nActionType = VWFunctionStrings.getActionType(shape.getDesignerObjectName());
                    if (VWActionType.isValid(nActionType)) {
                        mapNode = VWStepFactory.createSystemStep(this.m_myMapDef, stepName, ptLoc, nActionType);
                    } else if (VWStringUtils.compare(shape.getDesignerObjectName(), VWResource.s_component) == 0) {
                        mapNode = VWStepFactory.createComponentStep(this.m_myMapDef, stepName, ptLoc);
                    } else if (VWStringUtils.compare(shape.getDesignerObjectName(), VWResource.s_general) == 0) {
                        mapNode = VWStepFactory.createGeneralStep(this.m_myMapDef, stepName, ptLoc);
                    } else if (VWStringUtils.compare(shape.getDesignerObjectName(), VWResource.s_system) == 0) {
                        mapNode = VWStepFactory.createSystemStep(this.m_myMapDef, stepName, ptLoc, -1);
                    } else if (VWStringUtils.compare(shape.getDesignerObjectName(), VWResource.s_submap) == 0 && (mapNode = VWStepFactory.createSubmapStep(this.m_myMapDef, stepName, ptLoc)) != null && shape.getSubmapName() != null && (instructionDefs = ((VWCompoundStepDefinition)mapNode).getInstructions()) != null && instructionDefs.length > 0) {
                        VWInstruction.CallInstructionSetSubmap(instructionDefs[0], shape.getSubmapName());
                    }
                }
            }
            if (mapNode != null) {
                shape.setApiObject(mapNode);
            }
            return mapNode;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private Point getShapeLocation(Shape shape, VWMappingHelper mappingHelper, int nPageHeight) {
        shape.setXPos(shape.getPinX() + this.m_pinXOffset);
        shape.setYPos(shape.getPinY() + this.m_pinYOffset);
        double xPos = shape.getXPos() * (double)mappingHelper.getLocationPadding();
        double yPos = shape.getYPos() * (double)mappingHelper.getLocationPadding();
        return new Point((int)xPos, nPageHeight - (int)yPos);
    }

    private void addRoute(Shape shape, VWMappingHelper mappingHelper) {
        try {
            Shape toShape;
            Shape fromShape = shape.getFromShape();
            if (fromShape != null && fromShape.getApiObject() != null && fromShape.getApiObject() instanceof VWMapNode && (toShape = shape.getToShape()) != null && toShape.getApiObject() != null && toShape.getApiObject() instanceof VWMapNode) {
                VWMapNode fromNode = (VWMapNode)fromShape.getApiObject();
                VWMapNode toNode = (VWMapNode)toShape.getApiObject();
                if (fromNode.getStepId() == toNode.getStepId()) {
                    return;
                }
                if (this.routeAlreadyExists(fromNode, toNode.getStepId())) {
                    return;
                }
                VWRouteDefinition routeDef = fromNode.createRoute(toNode.getStepId());
                if (shape.getText() != null) {
                    routeDef.setName(shape.getText());
                }
                return;
            }
            mappingHelper.addMessage(2, VWResource.s_invalidRoute.toString(shape.getNameU(), shape.getID()));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            mappingHelper.addMessage(2, ex.getLocalizedMessage());
        }
    }

    private boolean routeAlreadyExists(VWMapNode sourceNode, int nDestinationNodeId) {
        try {
            VWRouteDefinition[] routeDefs = sourceNode.getNextRoutes();
            if (routeDefs != null) {
                for (int nIndex = 0; nIndex < routeDefs.length; ++nIndex) {
                    if (routeDefs[nIndex].getDestinationStepId() != nDestinationNodeId) continue;
                    return true;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return false;
    }

    private void addTextAnnotation(Shape shape, VWMappingHelper mappingHelper, int nPageHeight) {
        try {
            Point ptLoc = this.getShapeLocation(shape, mappingHelper, nPageHeight);
            VWTextAnnotationDefinition annoDef = this.m_myMapDef.createTextAnnotation(shape.getText());
            annoDef.setLocation(ptLoc);
            shape.setApiObject(annoDef);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void addAssociation(Shape shape, VWMappingHelper mappingHelper) {
        try {
            Shape fromShape = shape.getFromShape();
            Shape toShape = shape.getToShape();
            if (fromShape != null && fromShape.getApiObject() != null && toShape != null && toShape.getApiObject() != null) {
                if (fromShape.getApiObject() instanceof VWTextAnnotationDefinition || toShape.getApiObject() instanceof VWTextAnnotationDefinition) {
                    if (!(fromShape.getApiObject() instanceof VWTextAnnotationDefinition)) {
                        fromShape = shape.getToShape();
                        toShape = shape.getFromShape();
                    }
                    VWTextAnnotationDefinition textAnno = (VWTextAnnotationDefinition)fromShape.getApiObject();
                    VWAssociationDefinition associationDef = null;
                    if (toShape.getApiObject() instanceof VWMapNode) {
                        VWMapNode toNode = (VWMapNode)toShape.getApiObject();
                        associationDef = textAnno.createAssociation(toNode.getStepId(), 1);
                    } else if (toShape.getApiObject() instanceof VWRouteDefinition) {
                        VWRouteDefinition routeDef = (VWRouteDefinition)toShape.getApiObject();
                        associationDef = textAnno.createAssociation(routeDef.getRouteId(), 2);
                    }
                    if (associationDef != null) {
                        if (shape.getText() != null) {
                            associationDef.setName(shape.getText());
                        }
                        return;
                    }
                } else if (fromShape.getApiObject() instanceof VWFieldDefinition || toShape.getApiObject() instanceof VWFieldDefinition) {
                    if (!(fromShape.getApiObject() instanceof VWFieldDefinition)) {
                        fromShape = shape.getToShape();
                        toShape = shape.getFromShape();
                    }
                    VWFieldDefinition fieldDef = (VWFieldDefinition)fromShape.getApiObject();
                    if (toShape.getApiObject() instanceof VWStepDefinition) {
                        VWStepDefinition stepDef = (VWStepDefinition)toShape.getApiObject();
                        stepDef.createParameter(fieldDef.getName(), 3, fieldDef.getName(), fieldDef.getFieldType(), fieldDef.isArray());
                        return;
                    }
                }
            }
            mappingHelper.addMessage(2, VWResource.s_invalidAssociation.toString(shape.getNameU(), shape.getID()));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

